-- events 

function OnLoad ()
    CacheSound ("sfx/activate_something.ogg");
    CacheSound ("sfx/gained_something.ogg");
	SetProperty ("/:enter_trans_duration", 0.5);
	SetProperty ("/:leave_trans_duration", 0.5);
end;


function OnEnter ()
    PlaySound ("sfx/activate_something.ogg");
end;

function OnLeave ()
end;


function OnClick (name)

	if (name == "NewGame") then
	    PlaySound ("sfx/gained_something.ogg");
		DeleteGameState ();
		InitNewGame ();
		Azkend_SetGameMode (GetVar ("GameMode"));
		if (GetVar ("GameMode") == "QUEST") then
			local value = GetProfileVar ("GameCompleted");
			if (not (value == nil) and not (value == "0")) then
				SetGameLevel (2);
				SwitchScreen ("WorldMap");
			else
				SetGameLevel (1);
				SwitchScreen ("StoryIntro");
			end;		
		else -- SURVIVAL
			SetGameLevel (1);
			--InitGameLevel ();
			SwitchScreen ("SurvivalMode");
		end;
		return;
	end;
	
	if (name == "Cancel") then
		PopScreen ();
		return;
	end;
end;


function OnUpdate (tdelta)

	akey = GetActiveScreenAnimKey ();

	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	SetProperty ("panel:position_offset.y", (1-trans) * 600);
	-- SetProperty ("heading:alpha", trans);
	SetProperty ("fader:alpha", trans + trans * 0.05 * math.sin (2*3.141592*akey));
end;

function OnDraw ()

end;
